

- globals
  Global
    sf = fallback(IntensityFromMidi(1,0), 0) // deactivate filters at start
    _unused = SetMainCameraExcludeMask(2+4)

    t_symir_slant =       FramePosFromMidi(3, 26) / 60
    t_symir_displace =    FramePosFromMidi(3, 28) / 60
    t_liquid_disc =       FramePosFromMidi(3, 30) / 60
    t_qubic_watery =      FramePosFromMidi(3, 32) / 60
    t_quat_liquid2 =      FramePosFromMidi(3, 34) / 60
    t_quat_liquid =       FramePosFromMidi(3, 36) / 60
    t_env_stars =         FramePosFromMidi(3, 38) / 60
    t_env_stars2 =        FramePosFromMidi(3, 40) / 60
    t_env_chrome =        FramePosFromMidi(3, 42) / 60
    t_env_chrome_trans =  FramePosFromMidi(3, 44) / 60
    t_env_retro =         FramePosFromMidi(3, 46) / 60
    t_env_retro2 =        FramePosFromMidi(3, 48) / 60
    t_env_trans =         FramePosFromMidi(3, 50) / 60
    t_env_chrome_lights = FramePosFromMidi(3, 52) / 60
    t_env_stars3 =        FramePosFromMidi(3, 54) / 60
    t_teapot =            FramePosFromMidi(3, 56) / 60
    t_david =             FramePosFromMidi(3, 58) / 60
    t_env_ember =         FramePosFromMidi(3, 60) / 60
    t_cam1 =              FramePosFromMidi(3, 62) / 60
    t_cam2 =              FramePosFromMidi(3, 64) / 60
    t_cam3 =              FramePosFromMidi(3, 66) / 60
//  logo =                FramePosFromMidi(3, 68) / 60
    t_balls =             FramePosFromMidi(3, 70) / 60
    t_env_end =           FramePosFromMidi(3, 72) / 60
    t_time =              FramePosFromMidi(3, 74) / 60

    a_symir_slant =       filter(FrameIntensityFromMidi(3, 26), sf * 0) 
    a_symir_displace =    filter(FrameIntensityFromMidi(3, 28), sf * 0) 
    a_liquid_disc =       filter(FrameIntensityFromMidi(3, 30), sf * 0) 
    a_qubic_watery =      filter(FrameIntensityFromMidi(3, 32), sf * 0) 
    a_quat_liquid2 =      filter(FrameIntensityFromMidi(3, 34), sf * 0) 
    a_quat_liquid =       filter(FrameIntensityFromMidi(3, 36), sf * 0) 
    a_env_stars =         filter(FrameIntensityFromMidi(3, 38), sf * 3)
    a_env_stars2 =        filter(FrameIntensityFromMidi(3, 40), sf * 3)
    a_env_chrome =        filter(FrameIntensityFromMidi(3, 42), sf * 0)
    a_env_chrome_trans =  filter(FrameIntensityFromMidi(3, 44), sf * 0)
    a_env_retro =         filter(FrameIntensityFromMidi(3, 46), sf * 0)
    a_env_retro2 =        filter(FrameIntensityFromMidi(3, 48), sf * 0)
    a_env_trans =         filter(FrameIntensityFromMidi(3, 50), sf * 0)
    a_env_chrome_lights = filter(FrameIntensityFromMidi(3, 52), sf * 0)
    a_env_stars3 =        filter(FrameIntensityFromMidi(3, 54), sf * 3)
    a_teapot =            filter(FrameIntensityFromMidi(3, 56), sf * 0)
    a_david =             filter(FrameIntensityFromMidi(3, 58), sf * 0)
    a_env_ember =         filter(FrameIntensityFromMidi(3, 60), sf * 0)
    a_cam1 =              filter(FrameIntensityFromMidi(3, 62), sf * 0)
    a_cam2 =              filter(FrameIntensityFromMidi(3, 64), sf * 0)
    a_cam3 =              filter(FrameIntensityFromMidi(3, 66), sf * 0)
    a_balls =             filter(FrameIntensityFromMidi(3, 70), sf * 0)
    a_env_end =           filter(FrameIntensityFromMidi(3, 72), sf * 3)

    ccFilter =              IntensityFromMidiCC(1,15)
    ccFocX =         filter(             MidiCC(1,16), sf * nnFilterFocusPos)
    ccFocY =         filter(             MidiCC(1,17), sf * nnFilterFocusPos)
    ccFocRot =       filter( MidiCC(1,18) / 128      , sf * 0, 0, 1) * 360
    ccZoom =       1-filter(IntensityFromMidiCC(1,19), sf * ccFilter)
    ccZoomRaster = pow(1 - IntensityFromMidiCC(1,20), 2) + 0.03
    zoom = ccZoom * ccHardZoom
    zoomRaster =     filter(zoom * ccZoomRaster      , sf * 2.0)

    ccPaperOffset =  filter(IntensityFromMidiCC(1,21), sf * 4, 0, 1) 
    ccPattern =             IntensityFromMidiCC(1,22)
    nnGlyphNoise =          IntensityFromMidiCC(1,26) + IntensityFromMidi(1,15)
    nnGlyphNoiseType =      IntensityFromMidiCC(1,27)
    nnGlyphNoiseMinLum =    IntensityFromMidiCC(1,28)
    nnGlyphNoiseMaxLum =    IntensityFromMidiCC(1,30)
    ccHardZoom =         (1-IntensityFromMidiCC(1,25)) * 2
    ccText2Gain =         IntensityFromMidiCC(1,41)
    ccText2Scale =         IntensityFromMidiCC(1,46  )
    cc3D =           filter( MidiCC(1,84) / 128     ,  sf * 0.5, 0, 1) * 360
    cc3DScale = 1.0 - 0.5 * filter( IntensityFromMidiCC(1,85), 0.5 )
    ccGlitchPaper =         IntensityFromMidiCC(1,93)      
    ccPaperAmount = 1 + 1*ccGlitchPaper
    ccBlack =               IntensityFromMidiCC(1,94)      

    ccGlitch =              IntensityFromMidiCC(1,14)
    ccOrbit =        filter(IntensityFromMidiCC(1,86), sf * 1.7, 0, 1)
    ccOrbitTilt =    filter(IntensityFromMidiCC(1,88), sf * 1.5, 0)
    ccDolly =        filter(IntensityFromMidiCC(1,89), sf * 1)
    ccFOV =          filter(IntensityFromMidiCC(1,90), sf * 1)
    ccCamY =         filter(IntensityFromMidiCC(1,92), sf * 1)
    nc = 1
    bleedFix = 0.5/64

    nnFilterFocusPos = 1 // 
    nnPolarCoords =    IntensityFromMidi(1,1)
    nnColInv = IntensityFromMidi(1,2)
    nnRed = 1 - IntensityFromMidi(1,3)
    nnTextBankSwitch = IntensityFromMidi(1,6)
    nn28 = IntensityFromMidi(1,28)
    nn29 = IntensityFromMidi(1,29)
    

    red = [0.783, 0.27, 0, 1] 
    gray = [1.93*0.23, 2.06*0.23, 2.21*0.23, 1] 
    warmWhite = [3.18, 3.16, 2.9, 0.28 * 4]/2
    denim = [0.34, 0.42, 0.57, 0.25] * 2 
    denimDark = [0.29, 0.31, 0.38, 1/4]*2 

    textColor =  mix( mix(warmWhite, gray,      nnColInv)   , red  , nnRed)
    bgColor =    mix( mix(denimDark, warmWhite, nnColInv)   , denim, nnRed)  

    textColor2 =  warmWhite 
    bgColor2 = [0,0,0,0]
    
    nnGlyphScale = select( IntensityFromMidi(1,12) <= 0, 1, 1.06 - IntensityFromMidi(1,12))
    nnGlyphGlitch =  1.0 - IntensityFromMidi(1,13)
    nnGlyphNoiseSeed =     NoteOnTimestampFromMidi(1,14) * 100
    nnGlyphNoiseNoiseCoord = IntensityFromMidi(1,19)
    nnGlyphNoise2 =         IntensityFromMidi(1,20)
    nnColorOffset =     IntensityFromMidi(1,21)

    ccLightSize =       IntensityFromMidiCC(1,11)
    lightSize = 26 * ccLightSize
    meldecay = max(9, 24 * ccLightSize) 

    mel1 = lightSize * impact(time - NoteOnTimestampFromMidi(1,22), 0.0, meldecay, 12) 
    mel2 = lightSize * impact(time - NoteOnTimestampFromMidi(1,23), 0.0, meldecay, 12) 
    mel3 = lightSize * impact(time - NoteOnTimestampFromMidi(1,24), 0.0, meldecay, 12) 
    mel4 = lightSize * impact(time - NoteOnTimestampFromMidi(1,25), 0.0, meldecay, 12) 

    kick = impact(time - NoteOnTimestampFromMidi(1, 26), 0.0, 5, 12)  
    snare =  impact(time - NoteOnTimestampFromMidi(1, 27), 0.0, 3, 12)  


//    cubeMesh = LoadMesh('cube.obj')

 
- BLACK
  ShaderRect ; Shader = 'black-fade-on-top' ; Intensity = 1 - ccBlack
  

- env_default
  EnvironmentPreset ; Resource = "presets/env_default.kv"
- env_trans
  EnvironmentPreset ; Resource = "presets/env_trans.kv" ; Amount = a_env_trans
- env_chrome
  EnvironmentPreset ; Resource = "presets/env_chrome.kv" ; Amount = a_env_chrome
- env_end
  EnvironmentPreset ; Resource = "presets/env_end.kv" ; Amount = a_env_end
 
- env_ember
  Global
    emberT = t_env_ember * 0.15 % 1
    emberStr = rsmul(1-emberT, 0.05) * 4
  EnvironmentPreset ; Resource = "presets/env_ember2.kv" ; Amount = a_env_ember * (1 - nn28)
    // EnvironmentExposure = 0.57 * smootherstep(7,18,t_env_ember)
    EnvBalance = rsmul(smootherstep(7,18,t_env_ember), 0.26) - 1
    PlaneColor = color(2*emberStr,7*emberStr,36*emberStr, 0.5)
    PlaneLightSize = pow(emberT,3) * 40
    StarRotx = 70 + t_env_ember * 3
    StarRotY = 15 + t_env_ember * 3 
    //Light1 = vec4( 0,0,0,0)
    //Light2 = vec4( 0,0,0,0)
    Light1 = vec4( 37,2.4,8,28 * (0.0 + 0.1*max(0, mel3)))
    Light2 = vec4( 6,2.7,20,10 * (0.0 + 0.2*max(0, mel4)))
    Light3 = vec4( 0.3,  0.33,  0   , 0.34 * (0.1 + 2.2*kick))
    Light3Color = color(0.7, 0.14, 0.09, 1)
    Light4 = vec4(-0.17, 1.03, -0.82, 0.34 * (0.1 + 1.4*snare))    
    Light4Color = color(1.1, 0.76, 0.21, 1)

- env_chrome_lights
  EnvironmentPreset ; Resource = "presets/env_chrome_lights.kv" ; Amount = a_env_chrome_lights
    Light1 = vec4(0, 8.5, 20.5, 15.1 * (0.1 + 1.5*kick))
    Light2 = vec4(-21, 11.48, 17.6, 1.46 * (0.1 + 1.4*snare))
    Light3 = vec4( 6.2, 3.35, -1.53, 5.63 * (0.2 + max(mel1, mel3)))
    Light4 = vec4( 0.08, 0.87, -4.76, 6.2 * (0.2 + max(mel2, mel4)))
    StarRotZ = 30 + t_env_chrome_lights * 2 
  EnvironmentPreset ; Resource = "presets/env_chrome_trans.kv" ; Amount = a_env_chrome_trans
- env_retro
  EnvironmentPreset ; Resource = "presets/env_retro.kv" ; Amount = a_env_retro
    StarRotX = 50 + t_env_retro * 2 
- env_retro2
  EnvironmentPreset ; Resource = "presets/env_retro2.kv" ; Amount = a_env_retro2
    StarRotX = 50 + t_env_retro2 * 2 
    Light1 = vec4(lSize * sin(lt          ), 0.5 + sin(lt/3), lSize * cos(lt), 0.2 * mel1)
    Light1Color = color(0.7, 0.14, 0.09, 1)
    
    Light2 = vec4(lSize * sin(lt + lto    ), 0.5 + sin(lt/3), lSize * cos(lt + lto), 0.2 * mel2)
    Light2Color = color(1, 0.66, 0.11, 1)

    Light3 = vec4(lSize * sin(lt + lto * 2), 0.5 + sin(lt/3), lSize * cos(lt + lto * 2), 0.2 * mel3)
    Light3Color = color(0, 0.66, 0.11, 1)

    Light4 = vec4(lSize * sin(lt + lto * 3), 0.5 + sin(lt/3), lSize * cos(lt + lto * 3), 0.2 * mel4)
    Light4Color = color(0.11, 0.14, 1.5, 1)
- env_stars
  EnvironmentPreset ; Resource = "presets/env_stars.kv" ; Amount = a_env_stars
    Light1 = vec4(-1.2, 0.45, -0.5, 0.2 * mel1)
    Light1Color = color(0.7, 0.14, 0.09, 1)
    Light2 = vec4(-0.4, 0.45, -0.5, 0.2 * mel2)
    Light2Color = color(1, 0.66, 0.11, 1)
    Light3 = vec4( 0.4, 0.45, -0.5, 0.2 * mel3)
    Light3Color = color(0, 0.66, 0.11, 1)
    Light4 = vec4( 1.2, 0.45, -0.5, 0.2 * mel4)
    Light4Color = color(0.11, 0.14, 1.5, 1)
- env_stars2
  EnvironmentPreset ; Resource = "presets/env_stars2.kv" ; Amount = a_env_stars2
- env_stars3
  Global
    lt = 0 - t_time + nn28  
    lto = 0.6 + 0.3 * sin(lt)
    lSize = 1.2 //+ 1 - a_env_stars3
  EnvironmentPreset ; Resource = "presets/env_stars3.kv" ; Amount = max(a_env_stars3, nn28)
    StarRotY = 30 + t_env_stars3 * 5 
    GridOffset = mix(0.97, 0.93, max(kick, snare)) 
    PlaneLightSize = 2 + 0.2 * max(kick, snare) // 3.89

    Light1 = vec4(lSize * sin(lt          ), (1-nn28) * (0.5 + 0.5 * cos((lt          )*0.6)), lSize * cos(lt), 0.2 * max(nn28,mel1))
    Light1Color = color(0.7, 0.14, 0.09, 1)
    
    Light2 = vec4(lSize * sin(lt + lto    ), (1-nn28) * (0.5 + 0.5 * cos((lt + lto    )*0.6)), lSize * cos(lt + lto), 0.2 * max(nn28,mel2))
    Light2Color = color(1, 0.66, 0.11, 1)

    Light3 = vec4(lSize * sin(lt + lto * 2), (1-nn28) * (0.5 + 0.5 * cos((lt + lto * 2)*0.6)), lSize * cos(lt + lto * 2), 0.2 * max(nn28,mel3))
    Light3Color = color(0, 0.66, 0.11, 1)

    Light4 = vec4(lSize * sin(lt + lto * 3), (1-nn28) * (0.5 + 0.5 * cos((lt + lto * 3)*0.6)), lSize * cos(lt + lto * 3), 0.2 * max(nn28,mel4))
    Light4Color = color(0.11, 0.14, 1.5, 1)
    
- env_balls
  Global
    lt2 = t_balls / 2
    lto2 = 1
    lSize2 = 0.5  
    mSizeAnim = 0.05 * nn29
    mSize = 0.18
    metaFilter = 0.03
    Ball1 = [lSize2 * sin(lt2                  + 1) , 0.2 + lSize2 * (1 + sin(lt2*1.0)), lSize2 * cos(lt2 * 0.8)           , 0.2 * filter(mel1, metaFilter)]
    Ball2 = [lSize2 * sin(lt2 * 1.2 + lto2     + 2) , 0.2 + lSize2 * (1 + sin(lt2*1.2)), lSize2 * cos(lt2 * 0.9 + lto2)    , 0.2 * filter(mel2, metaFilter)]
    Ball3 = [lSize2 * sin(lt2 * 1.4 + lto2 * 2 + 3) , 0.2 + lSize2 * (1 + cos(lt2*1.1)), lSize2 * cos(lt2 * 0.8 + lto2 * 2), 0.2 * filter(mel3, metaFilter)]
    Ball4 = [lSize2 * sin(lt2 * 0.9 + lto2 * 3 + 4) , 0.2 + lSize2 * (1 + sin(lt2*0.9)), lSize2 * cos(lt2 * 1.2 + lto2 * 3), 0.2 * filter(mel4, metaFilter)]
  EnvironmentPreset ; Resource = "presets/env_balls.kv" ; Amount = a_balls
    StarRotZ = 30 + t_balls * 2 
    Light1 = Ball1 -> vec4  
    Light1Color = color(0.7, 0.14, 0.09, 1)
    Light2 = Ball2 -> vec4
    Light2Color = color(1, 0.66, 0.11, 1)
    Light3 = Ball3 -> vec4
    Light3Color = color(0, 0.66, 0.11, 1)
    Light4 = Ball4 -> vec4
    Light4Color = color(0.11, 0.14, 1.5, 1)





- rm_master 
  RayMarchControl ; Resource = "presets/rm_master.kv"                    
  - rm_base
    RayMarchControl ; Resource = "presets/rm_base.kv"                    

  - rm_symir
    RayMarchControl ; Resource = "presets/rm_symir.kv"

  - rm_symir_slant
    RayMarchControl ; Resource = "presets/rm_symir_slant.kv" ; Amount = a_symir_slant

  - rm_symir_displace
    RayMarchControl ; Resource = "presets/rm_symir_displace.kv" ; Amount = a_symir_displace
      DisplaceShift = t_symir_displace / 12

  - rm_liquid_disc
    RayMarchControl ; Resource = "presets/rm_liquid_disc.kv"  ; Amount = a_liquid_disc
      FractalTime1 = t_liquid_disc / 12
      DisplaceShift = t_liquid_disc / 5

  - rm_qubic_watery
    RayMarchControl ; Resource = "presets/rm_qubic_watery.kv" ; Amount = a_qubic_watery
      FractalTime2 = t_qubic_watery / 12

  - rm_quat_liquid2_start
    RayMarchControl ; Resource = "presets/rm_quat_liquid2_start.kv" ; Amount = a_quat_liquid2
  - rm_quat_liquid2_end
    RayMarchControl ; Resource = "presets/rm_quat_liquid2_end.kv"
      Amount = a_quat_liquid2 * t_quat_liquid2 / 20

  - rm_quat_liquid
    RayMarchControl ; Resource = "presets/rm_quat_liquid.kv" ; Amount = a_quat_liquid
      FractalTime1 = t_quat_liquid / 22
      DisplaceShift = 0-t_quat_liquid / 6  

  - rm_balls
    RayMarchControl ; Resource = "presets/rm_balls.kv" ; Amount = a_balls
      Ball1 = (Ball1 * [1,1,1,mSizeAnim] + [0, 0, 0, 0.04 * sin(lt2 * 0.81 +1) + mSize]) -> vec4
      Ball2 = (Ball2 * [1,1,1,mSizeAnim] + [0, 0, 0, 0.04 * sin(lt2 * 0.92 +2) + mSize]) -> vec4
      Ball3 = (Ball3 * [1,1,1,mSizeAnim] + [0, 0, 0, 0.04 * sin(lt2 * 0.93 +4) + mSize]) -> vec4
      Ball4 = (Ball4 * [1,1,1,mSizeAnim] + [0, 0, 0, 0.04 * sin(lt2 * 1    +5) + mSize]) -> vec4

  - rm_override
    RayMarchControl ; Resource = "presets/rm_override.kv"





//    RayMarchControl ; Resource = "presets/rm_ball.kv"                        ; Amount = filter(sign(IntensityFromMidi(1, 48)), noteOnSmooth)
   
- PRINT SIMULATION
  Global
    glitch = LoadTexture('analog-glitch.png')
    halftone = ProceduralTexture('halftone', width = 1024, height = 1024, mipmap = 0, filter = 'trilinear', _ExportN = 8, _Type = 2, _InvertPattern = 1, _DisplaceUV = 0.03, _NoiseAmount = 0.024)
//    printSimMat = Material(shader = 'print-sim', texture = offscrBuf[0], _GlitchTex = glitch, _HalftoneTex = halftone, _PaperOffset = ccPaperOffset, _PaperScale = zoomRaster, _Aspect = screenHeight / screenWidth, _GlitchAmount = ccGlitchPaper, _PaperAmount = ccPaperAmount, _Offset = nnColorOffset)
// glitch amount 0.19, halftone size 0.037, Gamma 1
    printSimMat = Material(shader = 'print-sim', texture = offscrBuf[0], _GlitchTex = glitch, _HalftoneTex = halftone, _PaperOffset = ccPaperOffset, _PaperScale = zoomRaster, _Aspect = screenHeight / screenWidth, _GlitchAmount = ccGlitchPaper, _GlitchB = -1.2, _PaperAmount = 0.15 + (1 - zoomRaster) * 1.0, _Offset = nnColorOffset, _Blacks = 0, _Saturation = 2, _Warming = 0.55, _PaperSoftness = 0.2 + 0.1 * (1 - zoomRaster))
  ShaderRect ; MaterialRef = printSimMat 

- teapot
  MeshStack ; Resource = "utah_teapot.obj" ; Material = ReflectiveMaterial ; RenderGroup = 2
    Matrix = MatrixFromTRS(0, 0.37 + 0.4 * (1 - cos(t_teapot / 10)), 0,   0, t_teapot * 10, 0,  1.0 * a_teapot)
 

- david
  MeshStack ; Resource = "david_soft.obj" ; Material = ReflectiveMaterial ; RenderGroup = 2
    Matrix = MatrixFromTRS(2.2, 1.41, -1.04,   72.7, 679, 0,  1.81 * a_david)

  
- MAIN CAM TRANSFORM
  - MAIN CAM
    Global
//      fontTex = LoadTexture('virtual-display-font.png', filter = 'trilinear')
      offscrMaxSize = 960
      offscrMaxSizeMul = offscrMaxSize/max(screenWidth, 2 * offscrMaxSize)
      offscrScale = offscrMaxSizeMul * min(1, zoomRaster)
    OffscreenCamera ; ExcludeMask = 1+4 ; OutTexture = offscrBuf := [] ; Width = screenWidth * offscrScale ; Height = screenHeight * offscrScale ; DepthBits = 24
    - CAM base
      CameraControl ; Resource = "presets/cam_base.kv"   
    - cam1
      CameraControl ; Resource = "presets/cam1.kv" ; Amount = a_cam1
      CameraControl ; Resource = "presets/cam1_end.kv" ; Amount = smootherstep(0,1,a_cam1 * t_cam1 / 20)
    - CAM override
      CameraControl ; Resource = "presets/cam_override.kv"   
        Orbit =     360 * (ccOrbit-0.5) 
        TiltOrbit = 180 * (ccOrbitTilt-0.5)  
        Dolly = 10 * (ccDolly-0.5)
        Y = 3  * (ccCamY-0.5)
        FXBloom = a_env_end * 7
//        FXExposure = a_env_end * -0.4


//  - RenderText2
//    Global
//      textbuffer2N = 5
//      textbuffer2W = textbuffer2N * 11
//      textbuffer2H = textbuffer2N * 7
//      renderText2Mat = Material(shader = 'virtual-display', texture = fontTex, filter = 'trilinear', _Color = textColor2 -> color, _BgColor = bgColor2 -> color)
//    ShaderRect ; MaterialRef = renderText2Mat ; FillWidth = true ; Aspect = 1 ; RenderGroup = 2 ; Mesh = cubeMesh ; UseMainCamera = false
//      Matrix = MatrixFromTRS(0,0,8.7,  0,0,0,  5 / 1)
//    TextDisplay ; Columns = textbuffer2W ; Rows = textbuffer2H
//      Material = renderText2Mat
//      TextBuffer = textbuffer2[0]
//      FocusX = textbuffer2W / 2 + (((textbuffer2N - 1) / 2)%1)
//      FocusY = textbuffer2H / 2 + (((textbuffer2N - 1) / 2)%1)
//      FocusRows = (floor(ccText2Scale * 12) + 1) * zoom * (23/2)
//      Rotation = ccFocRot
//      Seed =          nnGlyphNoiseSeed
//      Noise =         nnGlyphNoise2
//      NoiseType =     nnGlyphNoiseType
//      NoiseMinLum =   nnGlyphNoiseMinLum
//      NoiseMaxLum =   nnGlyphNoiseMaxLum
//      NoiseCoord =    nnGlyphNoiseNoiseCoord       
//
//  - OFFSCREEN FEED TO TEXTBUFFER
//    OffscreenCamera ; ExcludeMask = 1+2 ; OutTexture = textbuffer2 := [] ; Width = textbuffer2W ; Height = textbuffer2H ; Filter = 'none'
//    CameraControl
//      FXAmount = 0
//
//  - LOGO  
//    ShaderRect ; Shader = "Unlit"
//      RenderGroup = 4
//      _Color = color(1,1,1,1) 
//    ShaderRect ; Material = "teadrinker-logo-anim"
//      RenderGroup = 4
//      Intensity = FrameIntensityFromMidi(3, 68) 
//      Aspect = -1.45
//      Matrix = MatrixFromTRS(0, -0.01, 1.15,  0,0,0, 4)
//      UseMainCamera = false
//      _Size = -0.32  // -0.6666
//      _LocalTime = FramePosFromMidi(3, 68) / 90
//      _Color = color(0, 4 * 1, 3/8, 1)
//      RenderQueue = 3006

- LOGO  
  ShaderRect ; Material = "teadrinker-logo-anim"
    RenderGroup = 2
    Intensity = FrameIntensityFromMidi(3, 68) 
    Aspect = 1
    Matrix = MatrixFromTRS(0, 1, 4,  0,0,0, 4)
    UseMainCamera = false
    _Size = 1
    _LocalTime = FramePosFromMidi(3, 68) / 90
    _Color = color(0.5, 0.5, 0.5, 1)
    RenderQueue = 3006

- cam_base         
  CameraControl
    FXAmount = 0
    FXBloom = 0


//- particles1
//  Particles ; Resource = "presets/particles1.kv"
//    Intensity = smoothstep(0, 0.5, ccParticlesSolo)
//    Size = localDefault + smoothstep(0.5, 1, ccParticlesSolo)
//    Matrix = MatrixFromTRS(0,1.5,0, 0,0,0, 1)
//    Color = hsvColor()
//    Size = 2
//    SizeV = 0.9
//    Intensity = 1
//    LifeDuration = 4
//    Flow = 0.2
//    EmitterSize = vec3(7,2.5,7)
//    Direction = vec3(-1,0,0)
//    RenderStyle = 32
//    Tail = 40
//    Velocity = 3
//    VelocityV = 2/3
//    Spread = 0.0


// - deck
//  MeshStack ; Resource = "deck_chair.obj" ; Material = Material("Unlit", LoadTexture("test.png"))

//- synctest
//  Global ; synctestMat = Material("EventAnimator", LoadTexture("test.png"))
//  ShaderRect ; MaterialRef = synctestMat  
//  EventAnimator ; Material = synctestMat
//  EventAnimatorInput ; TimeStamp = NoteOnTimestampFromMidi(nc, 36) ; UvRect = vec4(0,0, 1,1) ; StartHidden = false

//  ProceduralTexture()

//- texturetest
//  Global ; texturetestMat = Material(texture = ProceduralTexture('halftone', width = screenWidth, height = screenHeight, _ExportN = 16, _Type = 2))
//  ShaderRect ; MaterialRef = texturetestMat  

